<?php
class modpm_parser
{
	var $placeholders = array(
		'{user_id}',
		'{user_name}',
		'{moderator_id}',
		'{moderator_name}',
		'{item_id}',
		'{item_name}',
		'{source_id}',
	    '{source_name}',
		'{dest_id}',
		'{dest_name}',
		'{reason}',
		'{homepage_url}',
		'{forum_url}',
		'{bbtitle}',
		'{old_title}'
	);

	var $phrasetext = '';

	var $phrasetext_parsed = '';

	var $items = array();

	var $item_id = 0;

	var $item_type = '';

	var $action = '';

	var $source = 0;

	var $dest = 0;

	var $reason = '';

	var $extra = '';

	var $view_source = true;

	var $view_dest = true;

	var $recipient = '';

	var $vbulletin = null;

	function modpm_parser(&$vbobj)
	{
		$this->vbulletin =& $vbobj;
	}
	function parse_phrase()
	{

		if (strlen($this->phrasetext) < 1)
		{
			return false;
		}

		if (count($this->items) < 1)
		{
			$this->phrasetext_parsed = $this->phrasetext;

			return true;
		}

		foreach ($this->items AS $id => $text)
		{
			if (in_array($id, $this->placeholders))
			{
				$this->phrasetext = str_replace($id, $text, $this->phrasetext);
			}
		}
		$this->phrasetext_parsed = $this->phrasetext;

		return true;

	}
	function fetch_items()
	{
		switch ($this->item_type)
		{
			case 'thread':
				{
					$item_info_a = $this->vbulletin->db->query_first("SELECT title AS item_name, postuserid AS user_id, postusername AS user_name, dateline
						FROM " . TABLE_PREFIX . "thread
						WHERE threadid = " . $this->vbulletin->input->clean($this->item_id, TYPE_UINT));
					break;
				}
			case 'post':
			case 'attachment':
				{
					$item_info_a = $this->vbulletin->db->query_first("SELECT SUBSTRING(post.pagetext, 1, 60) AS item_name, post.userid AS user_id, post.username AS user_name,
							thread.threadid AS source_id, thread.title AS source_name, post.dateline AS dateline
						FROM " . TABLE_PREFIX . "post AS post
						LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
						WHERE postid=" . $this->vbulletin->input->clean($this->item_id, TYPE_UINT));

					break;
				}
		}
		if ($this->item_type == 'thread')
		{
			$this->canview($item_info_a['user_id'], $this->source, $this->dest);
			if ($this->view_source)
			{
				$source_name_a = $this->vbulletin->db->query_first("SELECT title_clean FROM " . TABLE_PREFIX . "forum WHERE forumid=" . $this->vbulletin->input->clean($this->source, TYPE_UINT));
			}
			if ($this->view_dest)
			{
				$dest_name_a = $this->vbulletin->db->query_first("SELECT title_clean FROM " . TABLE_PREFIX . "forum WHERE forumid=" . $this->vbulletin->input->clean($this->dest, TYPE_UINT));
			}

		}

		if ($this->item_type == 'post' AND $this->dest)
		{
			$dest_name_a = $this->vbulletin->db->query_first("SELECT title AS title_clean FROM " . TABLE_PREFIX . "thread WHERE threadid=" . $this->vbulletin->input->clean($this->dest, TYPE_UINT));
		}

		if ($this->item_type == 'thread' AND $this->action == 'edit_title')
		{
			$title_old = $item_info_a['item_name'];
			$item_info_a['item_name'] = $this->extra;
		}
		if ($this->vbulletin->options['be_modpm_agecutoff'])
		{
			$cutoff = TIMENOW - $this->vbulletin->options['be_modpm_agecutoff'] * 86400;

			if ($item_info_a['dateline'] < $cutoff)
			{
				return false;
			}
		}
		$item_info_a['item_name'] = str_replace('&lt;', '<', $item_info_a['item_name']);
		$item_info_a['item_name'] = str_replace('&gt;', '>', $item_info_a['item_name']);
		$item_info_a['item_name'] = str_replace('&quot;', '"', $item_info_a['item_name']);
		$this->set_items(array(
			'{user_id}'			=> $item_info_a['user_id'],
			'{user_name}'		=> $item_info_a['user_name'],
			'{moderator_id}'	=> $this->vbulletin->userinfo['userid'],
			'{moderator_name}'	=> $this->vbulletin->userinfo['username'],
			'{item_id}'			=> $this->item_id,
			'{item_name}'		=> $item_info_a['item_name'] . ($this->item_type == 'post' ? '...' : ''),
			'{source_id}'		=> ($this->item_type == 'thread' ? $this->source : $item_info_a['source_id']),
			'{source_name}'		=> ($this->item_type == 'thread' ? $source_name_a['title_clean'] : $item_info_a['source_name']),
			'{dest_id}'			=> $this->dest,
			'{dest_name}'		=> $dest_name_a['title_clean'],
			'{reason}'			=> $this->reason,
			'{homepage_url}'	=> $this->vbulletin->options['homeurl'],
			'{forum_url}'		=> $this->vbulletin->options['bburl'],
			'{bbtitle}'         => $this->vbulletin->options['bbtitle'],
			'{old_title}'		=> $title_old,
			));

		$this->recipient = $item_info_a['user_name'];
		return true;

	}
	function canview($userid = 0, $source = 0, $dest = 0)
	{
		$userinfo = fetch_userinfo($userid);
		cache_permissions($userinfo);
		$this->view_source = ($userinfo['forumpermissions']["$source"] & $this->vbulletin->bf_ugp_forumpermissions['canview']);
		$this->view_dest = ($userinfo['forumpermissions']["$dest"] & $this->vbulletin->bf_ugp_forumpermissions['canview']);

	}
	function check_recycle_bin()
	{

		if (($this->dest == $this->vbulletin->options['be_modpm_recyclebin']) AND ($this->item_type == 'thread') AND ($this->action == 'move'))
		{
			$this->action = 'delete';
		}
		if(($this->dest == $this->vbulletin->options['be_modpm_recyclebin']) AND ($this->item_type == 'post') AND ($this->action == 'move'))
		{
			$this->action = 'delete';
		}
	}
	function set_items($items_a)
	{
		if ((!is_array($items_a)) OR (count($items_a) < 1))
		{
			return false;
		}
		$this->items = $this->vbulletin->input->clean($items_a, TYPE_ARRAY_STR);

		return true;
	}
	function get_phrasetext_parsed()
	{
		return $this->vbulletin->input->clean($this->phrasetext_parsed, TYPE_STR);
	}
}
?>
